<?php

if ( ! defined( 'ABSPATH' ) ) {
	// Exit if accessed directly.
	exit;
}

$gallery_meta = get_post_meta( get_the_ID(), 'qodef_post_format_gallery_images', true );

if ( ! empty( $gallery_meta ) ) { ?>
	<div class="qodef-e-media-gallery qodef-swiper-container">
		<div class="swiper-wrapper">
			<?php
			$gallery_images = explode( ',', $gallery_meta );

			foreach ( $gallery_images as $image_id ) {
				?>
				<div class="qodef-e-media-gallery-item swiper-slide">
					<a itemprop="url" href="<?php the_permalink(); ?>">
						<?php echo wp_get_attachment_image( $image_id, 'full' ); ?>
					</a>
				</div>
			<?php } ?>
		</div>
		<div class="swiper-button-prev"><?php qi_render_svg_icon( 'slider-arrow-left' ); ?></div>
		<div class="swiper-button-next"><?php qi_render_svg_icon( 'slider-arrow-right' ); ?></div>
	</div>
<?php } else {
	// Include featured image.
	qi_template_part( 'blog', 'templates/parts/post-info/image' );
} ?>
