<?php

if ( !class_exists( 'OCBOffCanvas' ) ) {
    class OCBOffCanvas
 {
        public function __construct() {
            add_action( 'init', [ $this, 'onInit' ] );
            add_action( 'enqueue_block_editor_assets', [ $this, 'obEnqueueEditorAssets' ] );
            add_action( 'wp_enqueue_scripts', [ $this, 'obEnqueueViewAssets' ] );
        }

        public function onInit()
 {
            register_block_type( __DIR__ . '/build' );

        }

        public function obEnqueueEditorAssets() {
            wp_add_inline_script(
                'ocb-offcanvas-editor-script',
                'const obIsPipeChecker = ' . wp_json_encode( obIsPremium() ) . ';',
                'before'
            );

        }

        public function obEnqueueViewAssets() {
            wp_add_inline_script(
                'ocb-offcanvas-view-script',
                'const obIsPipeChecker = ' . wp_json_encode( obIsPremium() ) . ';',
                'before'
            );

        }
    }

    new OCBOffCanvas();
}