<?php

/**
 * Plugin Name: OffCanvas Block
 * Description: Display content box from the left, right, or bottom edge of the viewport.
 * Version: 2.0.0
 * Author: bPlugins
 * Author URI: http://bplugins.com
 * License: GPLv3
 * License URI: https://www.gnu.org/licenses/gpl-3.0.txt
 * Text Domain: offcanvas
 */
// ABS PATH
if ( !defined( 'ABSPATH' ) ) {
    exit;
}
if ( function_exists( 'ob_fs' ) ) {
    ob_fs()->set_basename( false, __FILE__ );
} else {
    // Constant
    define( 'OCB_VERSION', ( isset( $_SERVER['HTTP_HOST'] ) && 'localhost' === $_SERVER['HTTP_HOST'] ? time() : '2.0.0' ) );
    define( 'OCB_DIR_URL', plugin_dir_url( __FILE__ ) );
    define( 'OCB_DIR_PATH', plugin_dir_path( __FILE__ ) );
    // define( 'OCB_HAS_PRO', ( plugin_basename( __FILE__ ) === 'offcanvas-block-premium/index.php' ) );
    define( 'OCB_HAS_PRO', file_exists( OCB_DIR_PATH . 'vendor/freemius/start.php' ) );
    if ( !function_exists( 'ob_fs' ) ) {
        function ob_fs() {
            global $ob_fs;
            if ( !isset( $ob_fs ) ) {
                $fsLitePath = OCB_DIR_PATH . 'vendor/freemius-lite/start.php';
                $fsPath = OCB_DIR_PATH . 'vendor/freemius/start.php';
                if ( OCB_HAS_PRO ) {
                    require_once $fsPath;
                } else {
                    require_once $fsLitePath;
                }
                $config = array(
                    'id'                  => '21322',
                    'slug'                => 'offcanvas-block',
                    'type'                => 'plugin',
                    'public_key'          => 'pk_2a4d09776eadeb1d9e964dff7283e',
                    'is_premium'          => false,
                    'premium_suffix'      => 'Pro',
                    'has_premium_version' => true,
                    'has_addons'          => false,
                    'has_paid_plans'      => true,
                    'menu'                => array(
                        'slug'       => 'edit.php?post_type=offcanvas-block',
                        'first-path' => 'edit.php?post_type=offcanvas-block&page=demo_page#/welcome',
                    ),
                );
                $ob_fs = ( OCB_HAS_PRO && file_exists( $fsPath ) ? fs_dynamic_init( $config ) : fs_lite_dynamic_init( $config ) );
            }
            return $ob_fs;
        }

        // Init Freemius.
        ob_fs();
        do_action( 'ob_fs_loaded' );
    }
    // ... Your plugin's main file logic ...
    require_once OCB_DIR_PATH . "includes/class-obPlugin.php";
    new OCBPlugin();
}