<?php

iF( !class_exists( 'OCBPlugin' ) ) {
    class OCBPlugin {
        public function __construct() {
            add_action( 'plugins_loaded', [ $this, 'load_dependencies' ] );
            add_action( 'admin_enqueue_scripts', [ $this, 'obAdminScripts' ] );
            add_shortcode( 'offcanvas-block', [ $this, 'obShortcode' ] );
            
        }

        public function load_dependencies() {
            require_once OCB_DIR_PATH . 'includes/functions.php';
            require_once OCB_DIR_PATH . 'offcanvas-block.php';
            require_once OCB_DIR_PATH . 'includes/class-obAdmin.php';

        }

        public function obAdminScripts($screen): void {
            global $typenow;

           
            if('offcanvas-block'==$typenow || 'tools_page_demo_page' == $screen ){
                wp_enqueue_script( 'admin-post-js', OCB_DIR_URL . 'build/admin-post.js', [], OCB_VERSION, true );
                wp_enqueue_style( 'admin-post-css', OCB_DIR_URL . 'build/admin-post.css', [], OCB_VERSION );

                wp_enqueue_script( 'bpl-admin-dashboard-js', OCB_DIR_URL . 'build/admin-dashboard.js', [ 'react', 'react-dom' ], OCB_VERSION, true );
                wp_enqueue_style( 'bpl-admin-dashboard-css', OCB_DIR_URL . 'build/admin-dashboard.css', [], OCB_VERSION );

            }

             

            
        }


function obShortcode( $atts ) {
		$post_id = $atts['id'];
		$post = get_post( $post_id );

		if ( !$post ) {
			return '';
		}

		if ( post_password_required( $post ) ) {
			return get_the_password_form( $post );
		}

		switch ( $post->post_status ) {
			case 'publish':
				return $this->displayContent( $post );

			case 'private':
				if ( current_user_can( 'read_private_posts' ) ) {
					return $this->displayContent( $post );
				}
				return '';

			case 'draft':
			case 'pending':
			case 'future':
				if ( current_user_can( 'edit_post', $post_id ) ) {
					return $this->displayContent( $post );
				}
				return '';

			default:
				return '';
		}
	}

	function displayContent( $post ) {
    $content = apply_filters( 'the_content', $post->post_content );
    return $content;
}


    }

}


