<?php
// Exit if accessed directly.
if ( !defined( 'ABSPATH' ) ) {
    exit;
}

if ( !class_exists( 'OBAdmin' ) ) {
    class OBAdmin {
        public function __construct() {
           
            add_action( 'init', [ $this, 'obRegisterPostType' ] );
            add_action( 'admin_enqueue_scripts', [ $this, 'enqueueDashboardAssetes' ] );
            add_action( 'admin_menu', [ $this, 'obAdminSubmenu' ] );
            add_filter( 'manage_offcanvas-block_posts_columns', [ $this, 'ob_setCustomColumn_edit' ] );
            add_action( 'manage_offcanvas-block_posts_custom_column', [ $this, 'ob_manageCustomColumn' ], 10, 2 );

        }

        public function  obRegisterPostType() {
            $icon = "<svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 100 113' fill='white' stroke='white' stroke-width='2'>
  <path d='M38.1,91.3H-2.2c-2.2,0-3.9-1.7-3.9-3.9V12.6c0-2.2,1.7-3.9,3.9-3.9h40.3c2.2,0,3.9,1.7,3.9,3.9v74.8 
  C41.9,89.6,40.3,91.3,38.1,91.3z M-2.2,11.3c-0.8,0-1.3,0.5-1.3,1.3v74.8c0,0.8,0.5,1.3,1.3,1.3h40.3c0.8,0,1.3-0.5,1.3-1.3V12.6 
  c0-0.8-0.5-1.3-1.3-1.3H-2.2z' />
  
  <path d='M33.2,19.2l1.8-1.8c0.5-0.5,0.5-1.3,0-1.8c-0.5-0.5-1.3-0.5-1.8,0l-1.8,1.8l-1.8-1.8
  c-0.5-0.5-1.3-0.5-1.8,0c-0.5,0.5-0.5,1.3,0,1.8l1.8,1.8L27.8,21c-0.5,0.5-0.5,1.3,0,1.8s1.3,0.5,1.8,0l1.8-1.8l1.8,1.8
  c0.5,0.5,1.3,0.5,1.8,0c0.5-0.5,0.5-1.3,0-1.8L33.2,19.2z' />

  <path d='M102.2,91.3H23v-2.6h79.2c0.8,0,1.3-0.5,1.3-1.3V12.6c0-0.8-0.5-1.3-1.3-1.3H23V8.7h79.2 
  c2.2,0,3.9,1.7,3.9,3.9v74.8C106.1,89.6,104.4,91.3,102.2,91.3z' />

  <path d='M7.5,43.2h20.8c0.8,0,1.3,0.5,1.3,1.3l0,0c0,0.8-0.5,1.3-1.3,1.3H7.5c-0.8,0-1.3-0.5-1.3-1.3l0,0 
  C6.2,43.9,6.9,43.2,7.5,43.2z' />
  <path d='M4.9,49.7h26c0.8,0,1.3,0.5,1.3,1.3l0,0c0,0.8-0.5,1.3-1.3,1.3h-26c-0.8,0-1.3-0.5-1.3-1.3l0,0 
  C3.6,50.4,4.3,49.7,4.9,49.7z' />
  <path d='M7.5,56.2h20.8c0.8,0,1.3,0.5,1.3,1.3l0,0c0,0.8-0.5,1.3-1.3,1.3H7.5c-0.8,0-1.3-0.5-1.3-1.3l0,0 
  C6.2,56.9,6.9,56.2,7.5,56.2z' />
  <path d='M4.9,62.7h26c0.8,0,1.3,0.5,1.3,1.3l0,0c0,0.8-0.5,1.3-1.3,1.3h-26c-0.8,0-1.3-0.5-1.3-1.3l0,0 
  C3.6,63.4,4.3,62.7,4.9,62.7z' />
  <path d='M7.5,69.2h20.8c0.8,0,1.3,0.5,1.3,1.3l0,0c0,0.8-0.5,1.3-1.3,1.3H7.5c-0.8,0-1.3-0.5-1.3-1.3l0,0 
  C6.2,69.9,6.9,69.2,7.5,69.2z' />
</svg>";


            register_post_type(
                'offcanvas-block',
                [
                    'label'               => 'Offcanvas',
                    'labels'              => [
                        'add_new' => 'Add New Shortcode',
                        'add_new_item' => 'Add New Shortcode',
                        'edit_item' => 'Edit Shortcode',
                        'not_found' => 'No Shortcode found',
                    ],
                    'supports' => [ 'title', 'editor', 'revisions' ],
                    'show_in_rest' => true,
                    'public' => true,
                    'publicly_queryable' => false,
                    'menu_icon' => 'data:image/svg+xml;base64,' . base64_encode( $icon ),
                    'item_published' => 'Offcanvas Block Published',
                    'item_updated' => 'Offcanvas Block Updated',
                    'template' => [ [ 'ocb/offcanvas' ] ],
                    'template_lock' => 'all',
                   
                ]
            );
        }

        

        public function obAdminSubmenu() {
            $parent_slug = 'tools.php';

            add_submenu_page(
                'edit.php?post_type=offcanvas-block' ,
                'Demo and Help',
                'Demo & Help',
                'manage_options',
                'demo_page',
                [ $this, 'ob_render_demo_page' ]
            );
        }

        // pass dashboard data through inline script

        public function enqueueDashboardAssetes() {
            $data = [
                'version' => OCB_VERSION,
                'isPremium' => obIsPremium()
            ];
            wp_add_inline_script(
                'bpl-admin-dashboard-js',
                'const dashboardData = ' . wp_json_encode( $data ) . ';',
                'before'
            );
        }
        // render dashboard and  pass its data through data attributes

        public function ob_render_demo_page() {
        
            ?>
            <div id = 'ocb-admin-dashboard' data-info = '<?php echo esc_attr(wp_json_encode([
				'version' => OCB_VERSION,
				'isPremium' => obIsPremium()
			])); ?>'></div>
            <?php
        }

        public function ob_setCustomColumn_edit( $column ) {
            unset( $column[ 'date' ] );
            $column[ 'shortcode' ] = 'ShortCode';
            $column[ 'date' ] = 'Date';
            $column[ 'publisher' ] = 'Publisher';
            return $column;
        }

        public function ob_manageCustomColumn( $column_name, $post_id ) {
           
            if ( $column_name == 'shortcode' ) {
                echo '<div class="bPlAdminShortcode" id="bPlAdminShortcode-' . esc_attr( $post_id ) . '">
						<input value="[offcanvas-block id=' . esc_attr( $post_id ) . ']" onclick="copyBPlAdminShortcode(\'' . esc_attr($post_id) . '\')" readonly>
						<span class="tooltip">Copy To Clipboard</span>
					  </div>';
            }
            if ( $column_name == 'publisher' ) {
                echo 'bPlugins';
            }
        }
    }

    new OBAdmin();
}
