<?php
if (! defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
$api_key = get_post_meta($post->id(), '_brevo_api_key', true);

// Fetch all Brevo fields
$brevo_fields = class_ccf7_brevo_Integration_object()->ccf7b_brevo_api_response_get_field('attributes', $api_key);

// Get the Contact Form 7 form content and extract the shortcodes
$cf7_shortcodes = class_ccf7_brevo_Integration_object()->ccf7b_get_contact_from7_fields($post->id());

// Retrieve saved brevo settings
$saved_brevo_settings = get_post_meta($post->ID(), '_brevo_field_mappings', true) ?: []; // Default to empty array if not set

// Create a nonce field for security
$nonce = wp_create_nonce('save_brevo_settings');

if (class_ccf7_brevo_Integration_object()->ccf7b_verify_brevo_api_key($api_key)) {
?>

    <!-- WordPress form-table class for default styling -->
    <table class="form-table params-brevo">
        <thead>
            <tr>
                <th><?php esc_html_e('Brevo Field', 'centous-integration-for-contact-form-7-and-brevo'); ?></th>
                <th><?php esc_html_e('Contact Form 7 Field', 'centous-integration-for-contact-form-7-and-brevo'); ?></th>
            </tr>
        </thead>
        <tbody>
            <!-- Nonce field -->
            <input type="hidden" name="brevo_settings_nonce" value="<?php echo esc_attr($nonce); ?>">

            <?php foreach ($brevo_fields as $brevo_field) :
                // Access the necessary properties from each field
                $field_key = isset($brevo_field['field_key']) ? $brevo_field['field_key'] : strtolower($brevo_field['name']);
                $saved_value = isset($saved_brevo_settings[$field_key]) ? $saved_brevo_settings[$field_key] : '';
            ?>
                <tr>
                    <td><?php echo esc_html($brevo_field['name']); ?></td> <!-- Display the field name -->
                    <td>
                        <!-- WordPress default styling for selects -->
                        <select id="brevo_settings_<?php echo esc_attr($field_key); ?>" name="brevo_settings[<?php echo esc_attr($field_key); ?>]" class="regular-text">
                            <option value=""><?php esc_html_e('Select a form field', 'centous-integration-for-contact-form-7-and-brevo'); ?></option>
                            <?php foreach ($cf7_shortcodes as $shortcode) : ?>
                                <option value="<?php echo esc_attr($shortcode); ?>" <?php selected($saved_value, $shortcode); ?>>
                                    <?php echo esc_html($shortcode); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
<?php
}
?>