<?php
if (! defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
$api_key = get_post_meta($post->id(), '_brevo_api_key', true);
// $api_key = 'ddfsdgdsg';
$is_verified = false;


// Get the saved data
$field_mapping_data = get_post_meta($post->id(), '_brevo_field_mapping', true);

// If there's no saved data, set empty defaults
$name_value = isset($field_mapping_data['name']) ? esc_attr($field_mapping_data['name']) : '';
$email_value = isset($field_mapping_data['email']) ? esc_attr($field_mapping_data['email']) : '';



// Check if an API key exists and is valid
if (!empty($api_key) && class_ccf7_brevo_Integration_object()->ccf7b_verify_brevo_api_key($api_key)) {
    $is_verified = true;
}
if ($is_verified) {
    class_ccf7_brevo_Integration_object()->ccf7b_setting_section_brevo($post);
} else { ?>
    <!-- Message when API key is not verified -->
    <p><b><?php esc_html_e('Please enter and verify a valid Brevo API key to enable additional settings.', 'centous-integration-for-contact-form-7-and-brevo'); ?></b></p>
<?php } ?>
<br>
<div id="content-general" class="tab-content">
    <!-- General Settings Content -->
    <div class="inside">

        <form action=""></form>
        <form id="brevo-api-key-form" method="post" action="">
            <?php wp_nonce_field('save_brevo_settings', 'brevo_settings_nonce'); ?>

            <input type="hidden" name="post_id" id="brevo-post-id" value="<?php echo esc_attr($post->id()); ?>">
            <label for="brevo-api-key"><?php esc_html_e('API Key', 'centous-integration-for-contact-form-7-and-brevo'); ?></label>
            <input type="text" name="brevo-api-key" id="brevo-api-key" value="<?php echo esc_attr($api_key); ?>" class="regular-text">

            <input type="submit" class="button button-primary verify-button" value="<?php esc_attr_e('Verify', 'centous-integration-for-contact-form-7-and-brevo'); ?>">
        </form>
        <div id="brevo-message" style="margin-top: 10px;"></div>
    </div>
</div>

<div id="content-field-mapping" class="tab-content" style="display: none;">
    <?php
    class_ccf7_brevo_Integration_object()->ccf7b_field_mapping_section($post);
    ?>
</div>
<div id="content-documentation-support" class="tab-content" style="display: none;">
    <?php
    class_ccf7_brevo_Integration_object()->ccf7b_documentation_section();
    ?>
</div>