{# separator template #}
{% set separator_template %}
  <span class="uc-breadcrumb-separator">{% if show_separator == "Text" %}{{separator}}{% elseif show_separator == "icon" %}{{separator_icon_html|raw}}{% endif %}</span>
{% endset %}

{% if uc_inside_editor == "yes" %}
    <div id="{{uc_id}}" class="uc-breadcrumbs">
        <ul class="uc-breadcrumbs-list {{skin}}">
          {% if show_home == "true" %}
            <li class="uc-breadcrumb-item">
              <a href="#" class="uc-item-title">
                <span class="uc-item-title-inner">
                  {% if show_index_numbers == "true" %}<span class="ue-index">1</span>{% endif %}
                  {% if show_home_icon == "true" %}<span class="ue-home-icon">{{home_icon_html|raw}}</span>{% endif %}
                  {{home_text}}
                </span>
              </a>
              {% if show_separator != "no" %}{{separator_template}}{% endif %}
            </li>
          {% endif %}
          
          {% if show_blog_page == "true" %}
            <li class="uc-breadcrumb-item">
              <a href="#" class="uc-item-title">
                <span class="uc-item-title-inner">
                  {% if show_index_numbers == "true" %}<span class="ue-index">2</span>{% endif %}
                  Blog
                </span>
              </a>
              {% if show_separator != "no" %}{{separator_template}}{% endif %}
            </li>
          {% endif %}
          
          {% if show_category_breadcrumbs == "true" %}
            {# Show categories based on max_category_depth #}
            {% set max_depth = max_category_depth|default(2) %}
            {% for i in 1..max_depth %}
              {% if categories_show_direction == "home" or categories_show_direction is not defined %}
                {% if i == 1 %}
                  <li class="uc-breadcrumb-item">
                    <a href="#" class="uc-item-title">
                      <span class="uc-item-title-inner">
                        {% if show_index_numbers == "true" %}<span class="ue-index">{{ show_blog_page == "true" ? i+2 : i+1 }}</span>{% endif %}
                        Parent Category
                      </span>
                    </a>
                    {% if show_separator != "no" %}{{separator_template}}{% endif %}
                  </li>
                {% elseif i == max_depth %}
                  <li class="uc-breadcrumb-item">
                    <a href="#" class="uc-item-title">
                      <span class="uc-item-title-inner">
                        {% if show_index_numbers == "true" %}<span class="ue-index">{{ show_blog_page == "true" ? i+2 : i+1 }}</span>{% endif %}
                        Category
                      </span>
                    </a>
                    {% if show_separator != "no" %}{{separator_template}}{% endif %}
                  </li>
                {% endif %}
              {% else %}
                {# From Page direction shows last categories #}
                {% if i == max_depth-1 %}
                  <li class="uc-breadcrumb-item">
                    <a href="#" class="uc-item-title">
                      <span class="uc-item-title-inner">
                        {% if show_index_numbers == "true" %}<span class="ue-index">{{ show_blog_page == "true" ? i+2 : i+1 }}</span>{% endif %}
                        Parent Category
                      </span>
                    </a>
                    {% if show_separator != "no" %}{{separator_template}}{% endif %}
                  </li>
                {% elseif i == max_depth %}
                  <li class="uc-breadcrumb-item">
                    <a href="#" class="uc-item-title">
                      <span class="uc-item-title-inner">
                        {% if show_index_numbers == "true" %}<span class="ue-index">{{ show_blog_page == "true" ? i+2 : i+1 }}</span>{% endif %}
                        Category
                      </span>
                    </a>
                    {% if show_separator != "no" %}{{separator_template}}{% endif %}
                  </li>
                {% endif %}
              {% endif %}
            {% endfor %}
          {% endif %}
          
          {% if show_current == "true" or show_current is not defined %}
          <li class="uc-breadcrumb-item uc-breadcrumb-current">
            <span class="uc-item-title">
              <span class="uc-item-title-inner">
                {% if show_index_numbers == "true" %}
                  {% set index = 1 %}
                  {% if show_home == "true" %}{% set index = index + 1 %}{% endif %}
                  {% if show_blog_page == "true" %}{% set index = index + 1 %}{% endif %}
                  {% if show_category_breadcrumbs == "true" %}{% set index = index + max_category_depth|default(2) %}{% endif %}
                  <span class="ue-index">{{ index }}</span>
                {% endif %}
                Page Title
              </span>
            </span>
          </li>
          {% endif %}
        </ul>
    </div>
{% else %}
    {% set breadcrumbs = ucfunc('get_breadcrumbs') %}
	{% set url = ucfunc("get_url_ajax") %}

    {% if breadcrumbs is not empty %}
        <div id="{{uc_id}}" class="uc-breadcrumbs">
            <ul class="uc-breadcrumbs-list {{skin}}">
                {% for breadcrumb in breadcrumbs %}
                    {% if breadcrumb.url is not empty %}
                        <li class="uc-breadcrumb-item">
                            <a href="{{ breadcrumb.url }}" class="uc-item-title">
                              <span class="uc-item-title-inner">
                                {% if show_index_numbers == "true" %}<span class="ue-index">{{loop.index}}</span>{% endif %}
                                {% if show_home_icon == "true" and loop.index == 1 %}<span class="ue-home-icon">{{home_icon_html|raw}}</span>{% endif %}
                                {{ breadcrumb.text|ucsafe|raw }}
                              </span>
                            </a>
                            {% if not loop.last and show_separator != "no" %}{{separator_template}}{% endif %}
                        </li>              		    
                    {% else %}
                        <li class="uc-breadcrumb-item uc-breadcrumb-current">
                           <span class="uc-item-title">
                              <span class="uc-item-title-inner">
                                {% if show_index_numbers == "true" %}<span class="ue-index">{{loop.index}}</span>{% endif %}
                                {{ breadcrumb.text|ucsafe|raw }}
                              </span>
                           </span>
                           {% if not loop.last and show_separator != "no" %}{{separator_template}}{% endif %}
                        </li>
                    {% endif %}
                {% endfor %}
            </ul>
        </div>

        {% if enable_schema == "true" %}    
          <script type="application/ld+json">
          {
            "@context": "https://schema.org",
            "@type": "BreadcrumbList",
            "itemListElement": [
              {% for breadcrumb in breadcrumbs %}
                {% if breadcrumb.url is not empty %}
                  {
                    "@type": "ListItem",
                    "position": {{loop.index}},
                    "name": "{{breadcrumb.text}}",
                    "item": "{{breadcrumb.url}}"
                  },
                {% else %}
                  {
                    "@type": "ListItem",
                    "position": {{loop.index}},
                    "name": "{{breadcrumb.text}}",
                    "item": "{{url}}"
                  }
                {% endif %}
              {% endfor %}
            ]
          }
          </script>
        {% endif %}{# end enable_schema #}{##}
    {% endif %}{# end breadcrumbs is not empty #}{##}
{% endif %}