{# twig vars #}{##}
{% set reviewsArray = reviews.reviews %}

{% set fullStarElem %}<div class="ue_rate">{{full_html|raw}}</div>{% endset %}
{% set halfStarElem %}<div class="ue_rate">{{half_html|raw}}</div>{% endset %}
{% set emptyStarElem %}<div class="ue_rate">{{empty_html|raw}}</div>{% endset %}

{% set marqueeItemClass %}{% if layout_type == "marquee" %}uc_logo_marquee_holder{% endif %}{% endset %}
{% set swipeItemClass %}{% if layout_type == "swipe" %}galleryItem{% endif %}{% endset %}
{% set gridItemClass %}{% if layout_type == "grid" %}ue_grid_item{% endif %}{% endset %}

{% set badgeReviewLinkHrefAttr %}
  {% if badge_review_link_type == "write" %}
    https://search.google.com/local/writereview?placeid={{reviews_google_reviews_place_id}}
  {% elseif badge_review_link_type == "view" %}
	https://search.google.com/local/reviews?placeid={{reviews_google_reviews_place_id}}
  {% elseif badge_review_link_type == "maps" %}
	https://www.google.com/maps/search/?api=1&query=Google&query_place_id={{reviews_google_reviews_place_id}}
  {% elseif badge_review_link_type == "custom" %}
    {{badge_review_link_custom}}
  {% endif %}
{% endset %}

{% set badgeReviewLinkTargetAttr %}
  {% if badge_review_link_type != "custom" %}
    target="_blank"
  {% endif %}
{% endset %}

{% set badgeElem %}
<div class="ue-google-reviews__badge">
  <div class="ue-google-reviews__badge-col">
    <div class="ue-google-reviews__badge-intro">
      {% if badge_image is not empty %}
        <div class="ue-google-reviews__badge-image"><img class="ue-google-reviews__badge-img" src="{{badge_image}}" {{badge_image_attributes|ucsafe|raw}}></div>
      {% endif %}
      {% if badge_title is not empty %}<div class="ue-google-reviews__badge-title">{{badge_title|ucsafe|raw}}</div>{% endif %}    
    </div>
    <div class="ue-google-reviews__badge-stat">
      {% if show_badge_rating_number == "true" %}<div class="ue-google-reviews__badge-rating">{{reviews.place_info.rating}}</div>{% endif %}
      {% if show_badge_stars == "true" %}
        <div class="ue-google-reviews__badge-stars">
          {% for i in 1..5 %}
            {% set difference = reviews.place_info.rating - (i - 1) %}

            {% if difference >= 1 %}
              {% set fill_percent = 100 %}
            {% elseif difference > 0 %}
              {% set fill_percent = (difference * 100)|round %}
            {% else %}
              {% set fill_percent = 0 %}
            {% endif %}

            <svg viewBox="0 0 14 14" xmlns="http://www.w3.org/2000/svg">
              <defs>
                {# Unique ID for each star's gradient #}{##}
                <linearGradient id="grad-{{ loop.index }}-{{ uc_id }}">
                  <stop offset="{{ fill_percent }}%" stop-color="{{badge_stars_color_full}}" />
                  <stop offset="{{ fill_percent }}%" stop-color="{{badge_stars_color_empty}}" />
                </linearGradient>
              </defs>
              <path d="M6.82617 11.442L3.54617 13.166C3.46353 13.2093 3.3704 13.2287 3.27732 13.2219C3.18425 13.2151 3.09494 13.1824 3.0195 13.1274C2.94406 13.0725 2.8855 12.9975 2.85045 12.911C2.8154 12.8245 2.80526 12.7299 2.82117 12.638L3.44817 8.98798C3.46192 8.908 3.456 8.82587 3.43091 8.74869C3.40582 8.67151 3.36232 8.6016 3.30417 8.54499L0.650168 5.95899C0.583317 5.89388 0.53602 5.81136 0.51363 5.72076C0.491239 5.63017 0.494647 5.53512 0.52347 5.44637C0.552292 5.35761 0.605378 5.27869 0.676721 5.21854C0.748065 5.15838 0.834818 5.1194 0.927168 5.10599L4.59317 4.57299C4.67344 4.56146 4.7497 4.53059 4.81537 4.48303C4.88105 4.43547 4.93418 4.37265 4.97017 4.29999L6.61017 0.977985C6.65153 0.894518 6.7154 0.824266 6.79455 0.775151C6.87371 0.726037 6.96501 0.700012 7.05817 0.700012C7.15132 0.700012 7.24263 0.726037 7.32178 0.775151C7.40094 0.824266 7.4648 0.894518 7.50617 0.977985L9.14717 4.29899C9.18307 4.37152 9.23604 4.43426 9.30153 4.48182C9.36702 4.52937 9.44308 4.56031 9.52317 4.57199L13.1892 5.10499C13.2815 5.1184 13.3683 5.15738 13.4396 5.21754C13.511 5.27769 13.564 5.35661 13.5929 5.44537C13.6217 5.53412 13.6251 5.62917 13.6027 5.71976C13.5803 5.81036 13.533 5.89288 13.4662 5.95798L10.8132 8.54398C10.7552 8.60049 10.7118 8.67024 10.6867 8.74723C10.6616 8.82422 10.6556 8.90616 10.6692 8.98598L11.2962 12.637C11.3122 12.7291 11.3021 12.8238 11.267 12.9105C11.232 12.9971 11.1733 13.0722 11.0977 13.1272C11.0221 13.1822 10.9326 13.2149 10.8393 13.2215C10.7461 13.2282 10.6528 13.2086 10.5702 13.165L7.29117 11.441C7.21946 11.4033 7.13967 11.3836 7.05867 11.3836C6.97767 11.3836 6.89788 11.4033 6.82617 11.441Z" 
                fill="url(#grad-{{ loop.index }}-{{ uc_id }})">
              </path>
            </svg>
          {% endfor %}
        </div>
      {% endif %}
      {% if show_badge_reviews_number == "true" %}<div class="ue-google-reviews__badge-total-reviews">{{text_before_badge_reviews_number|ucsafe|raw}}{{reviews.place_info.reviews}}{{text_after_badge_reviews_number|ucsafe|raw}}</div>{% endif %}
    </div>
  </div>
  <div class="ue-google-reviews__badge-col">
    {% if show_badge_review_link == "true" %}<a class="ue-google-reviews__badge-review-link" href="{{badgeReviewLinkHrefAttr}}" {{badgeReviewLinkTargetAttr}}>{{badge_review_link_text|ucsafe|raw}}</a>{% endif %}
  </div>
</div>
{% endset %}

{% set itemsHTML %}
  {% for item in reviewsArray %}
    {# twig vars #}{##}
    {% set rating = item.rating %}
    {# end twig vars #}{##}
     
    {% if (show_only_5_stars_reviews == "true" and rating == "5") or show_only_5_stars_reviews == "false" %}
	  {% if layout_type == "coverflow" %}
        <li class="ue-coverflow-item uc_quote_item ue-item {{item.item_repeater_class}}" data-flip-title="{% if navigation_type_coverflow == "title" %}{{item.title}}{% else %}{{item.item_index}}{% endif %}">                    
          <div class="ue-flip-item-content">
      {% else %}
        <div class="ue-google-reviews__item ue-item {{marqueeItemClass}} {{swipeItemClass}} {{gridItemClass}}">
      {% endif %}  
          <div class="ue-google-reviews__item-header">
            {% if show_author_photo == "true" and item.author_photo is not empty %}<div class="ue-google-reviews__item-image"><img class="ue-google-reviews__item-img" src="{{item.author_photo}}" alt="{{item.author_name}}" /></div>{% endif %}
            <div class="ue-google-reviews__item-header-content">
              {% if show_author_name == "true" %}<div class="ue-google-reviews__item-author-name">{{item.author_name|ucsafe|raw}}</div>{% endif %}
              {% if show_time_ago == "true" %}<div class="ue-google-reviews__item-time-ago">{{item.time_ago|ucsafe|raw}}</div>{% endif %}
            </div>
          </div>
          {% if show_rating == "true" %}
            <div class="ue-google-reviews__item-stars">
              {% if rating == "5" %}{% for i in 1..5 %}{{fullStarElem}}{% endfor %}{% endif %}
              {% if rating == "4.5" %}{% for i in 1..4 %}{{fullStarElem}}{% endfor %}{{halfStarElem}}{% endif %}
              {% if rating == "4" %}{% for i in 1..4 %}{{fullStarElem}}{% endfor %}{{emptyStarElem}}{% endif %}
              {% if rating == "3.5" %}{% for i in 1..3 %}{{fullStarElem}}{% endfor %}{{halfStarElem}}{{emptyStarElem}}{% endif %}
              {% if rating == "3" %}{% for i in 1..3 %}{{fullStarElem}}{% endfor %}{% for i in 1..2 %}{{emptyStarElem}}{% endfor %}{% endif %}
              {% if rating == "2.5" %}{% for i in 1..2 %}{{fullStarElem}}{% endfor %}{{halfStarElem}}{% for i in 1..2 %}{{emptyStarElem}}{% endfor %}{% endif %}
              {% if rating == "2" %}{% for i in 1..2 %}{{fullStarElem}}{% endfor %}{% for i in 1..3 %}{{emptyStarElem}}{% endfor %}{% endif %}
              {% if rating == "1.5" %}{{fullStarElem}}{{halfStarElem}}{% for i in 1..3 %}{{emptyStarElem}}{% endfor %}{% endif %}
              {% if rating == "1" %}{{fullStarElem}}{% for i in 1..4 %}{{emptyStarElem}}{% endfor %}{% endif %}
            </div>{# end ue-google-reviews__item-stars #}{##}
          {% endif %}{# end show_rating == "true" #}{##}
          {% if show_text == "true" and item.text is not empty %}
            <div class="ue-google-reviews__item-text ue-text">
              <div class="ue-google-reviews__item-text-item">{{item.text|ucsafe|raw}}</div>
            </div>
          	{% if show_unfold_content_button == "true" %}
              <button class="ue-text-unfold-btn">
                <span class="ue-text-folded">{{unfold_btn_text|ucsafe|raw}}</span>
                <span class="ue-text-unfolded">{{fold_btn_text|ucsafe|raw}}</span>
              </button>
            {% endif %}
          {% endif %}
          
      {% if layout_type == "coverflow" %}
          </div>{# end ue-flip-item-content #}{##}
        </li>{# end ue-google-reviews__item #}{##}
      {% else %}
        </div>{# end ue-google-reviews__item #}{##}
      {% endif %}            
	{% endif %}{# end if (show_only_5_stars_reviews == "true" and rating == "5") or show_only_5_stars_reviews == "false" #}{##}
  {% endfor %}
{% endset %}{# end set itemsHTML #}{##}

{# end twig vars #}{##}

<div id="{{uc_id}}" class="ue-google-reviews">
  
  {% if show_badge == "true" %}{{badgeElem}}{% endif %}
  
  {% if layout_type == "owl" %}
	<div class="ue-google-reviews__carousel owl-carousel uc-items-wrapper {{remote_parent.class}}" {{remote_parent.attributes|raw}}>
      {{itemsHTML}}
    </div>		
  {% endif %}
  
  {% if layout_type == "marquee" %}
    <div class="ue-google-reviews__marquee uc_logo_marquee uc_marquee_{{direction_marquee}}">
      <div class="uc_marquee uc-items-wrapper" data-height="{{box_height}}" data-speed="{{transition_speed_marquee}}" data-mobile-items="{{number_of_items_marquee_mobile}}" data-tablet-items="{{number_of_items_marquee_tablet}}" data-desktop-items="{{number_of_items_marquee}}" data-margin="{{margin_between_items_marquee}}" data-paused="{{autoplay_hover_pause_marquee}}" data-direction="{{direction_marquee}}">
        {{itemsHTML}}
      </div>	
    </div>
  {% endif %}
  
  {% if layout_type == "coverflow" %}
    <div class="ue-coverflow {{remote_parent.class|raw}} {% if remove_item_reflection_coverflow == "true" %}ue-coverflow-no-reflection{% endif %} {% if content_layout_coverflow == "overlay" %}ue-coverflow-overlay{% endif %}" {{remote_parent.attributes|raw}}>
      <ul class="flip-items uc-items-wrapper">
        {{itemsHTML}}
      </ul>
	</div>
  {% endif %}
  
  {% if layout_type == "swipe" %}
	<div class="swipe_css_carousel {% if snap_to_carousel_item_swipe == "true" %}swipe_css_carousel-snap{% endif %} {{uc_filtering_addclass}}" {{uc_filtering_attributes|raw}} data-show-title="{{show_title}}" data-show-text="{{show_text}}" data-justified-widths="{{justified_widths}}">
      <div class="startGap"></div>
      <div class="uc-items-wrapper">{{itemsHTML}}</div>
      <div class="endGap"></div>
    </div>
  {% endif %}
  
  {% if layout_type == "grid" %}
	<div class="team_member_grid uc-items-wrapper">
      {{itemsHTML}}
	</div>
  {% endif %}
  
</div>