#{{uc_id}}{
  min-height: 1px;
}

#{{uc_id}} .ue-google-reviews__badge{
  display: flex;
}

#{{uc_id}} .ue-google-reviews__item{
  display: flex;
  transition: all .3s ease;
}

#{{uc_id}} .ue-google-reviews__item-header{
  display: flex;
}

#{{uc_id}} .ue-google-reviews__badge-intro{
  display: flex;
  align-items: center;
}

#{{uc_id}} .ue-google-reviews__badge-stat{
  display: flex;
  align-items: center;
}

#{{uc_id}} .ue-google-reviews__badge-stars{
  display: flex;
}

#{{uc_id}} .ue-google-reviews__item-header-content{
  display: flex;
}

#{{uc_id}} .ue-google-reviews__item-stars{
  display: flex;
  line-height: 1;
}

#{{uc_id}} .ue-google-reviews__badge-review-link{
  transition: all .3s ease;
}

#{{uc_id}} .ue-google-reviews__item-image{
  flex-shrink: 0;
}

#{{uc_id}} .ue-google-reviews__badge-img{
  display: block;
  line-height: 1;
}

#{{uc_id}} .ue-google-reviews__item-img{
  display: inline-block;
}

#{{uc_id}} .ue-flip-item-content{
  transition: all .3s ease;
}

/* soft styles */
.ue-google-reviews__item-author-name{
  font-size: 15px;
  line-height: 18px;
  font-weight: 600;
}

.ue-google-reviews__item-time-ago{
  font-size: 12px;
  line-height: 16px;
}

.ue-google-reviews__badge-title{
  font-size: 20px;
  line-height: 26px;
  font-weight: 700;
}

.ue-google-reviews__badge-rating{
  font-size: 22px;
  line-height: 26px;
}

.ue-google-reviews__badge-total-reviews{
  font-size: 12px;
  line-height: 14px;
}
.ue-flip-item-content
{
  display:flex;
  flex-direction:column;
}
.ue-google-reviews__badge-review-link{
  font-size: 14px;
  line-height: 18px;
}
/* end soft styles */

{% if show_unfold_content_button == "true" %}
  #{{uc_id}} .ue-text-unfold-btn{
    cursor: pointer;
  }

  #{{uc_id}} .ue-text{
    overflow: hidden;
    transition: all .3s ease;
  }

  #{{uc_id}} .ue-text-unfolded{
    display: none;
  }
{% endif %}

/* layout type owl */
{% if layout_type == "owl" %}
  #{{uc_id}} .owl-dots {
    overflow:hidden;
  }

  #{{uc_id}} .owl-dot {
    display:inline-block;
    padding: 0;
  }

  {% if equal_height == "true" %}
    #{{uc_id}} .owl-stage{
	  display: flex;
    }
	
  	#{{uc_id}} .ue-google-reviews__item{
	  height: 100%;
	}
  {% endif %}

  #{{uc_id}} .owl-nav .owl-prev,
  #{{uc_id}} .owl-nav .owl-next{
      position:absolute;
      display:inline-block;
      text-align:center;
      padding: 0;
  }

  {% if transition_easing == "false" %}
  	#{{uc_id}} .owl-stage        {
       transition-timing-function: linear!important;
    }
  {% endif %}

  {% if make_3d == "true" %} 
    #{{uc_id}} .ue-item {
        opacity: 0.3;
        transform: scale3d(0.8, 0.8, 1);
        transition: all 0.3s ease-in-out;
    }

    #{{uc_id}} .active.center{
        z-index: 1;
    }

    #{{uc_id}} .active.center .ue-item {
        opacity: 1;
        transform: scale3d(1, 1, 1);
        transition: all 0.3s ease-in-out;
    }
  {% endif %}
{% endif %}

.ue-google-reviews [type=button], .ue-google-reviews [type=submit], .ue-google-reviews button{
  padding: 0;
  border: 0;
  background-color: unset;
  color: unset;
  border-radius: unset;
  font-size: unset;
}

.ue-google-reviews [type=button]:hover, .ue-google-reviews [type=submit]:hover, .ue-google-reviews button:hover{
  border: 0;
  background-color: unset;
  color: unset;
}

.ue-google-reviews [type=button]:focus, .ue-google-reviews [type=submit]:focus, .ue-google-reviews button:focus{
  border: 0;
  background-color: unset;
  color: unset;
}
/* end layout type owl */

/* layout type marquee */
{% if layout == "marquee" %}
  #{{uc_id}} .ue-google-reviews__marquee{
	direction: ltr;
  }
{% endif %}
/* end layout type marquee */

/* layout type swipe */
{% if layout == "swipe" %}
  #{{uc_id}} .startGap,
  #{{uc_id}} .endGap{
	height:10px;
    flex-shrink: 0;
  }
{% endif %}
/* end layout type swipe */

/* layout type grid */
{% if layout_type == "grid" %}
 #{{uc_id}} .team_member_grid{
  {% if grid_type == "regular" %}
    position:relative;
    display:grid;
  {% elseif grid_type == "masonry" %}
    padding: 0;
    position:relative;
  {% endif %}
}

 #{{uc_id}} .team_member_grid .ue_grid_item{
  {% if grid_type == "regular" %}
    position:relative;
    display:flex;
    flex-direction:column;
  {% elseif grid_type == "masonry" %}
	display: block;
    width: {{basewidth}};
    position:absolute;
    min-height: unset;
  {% endif %}	
}
{% endif %}
/* end carousel type grid */