
var UEFlipbox = function(flipboxID){
  
  //classes
  var g_ucShowClass, g_ucHideClass, g_classFront, g_classBack;
  
  //objects
  var g_objFlipBox, g_objTriggerFront, g_objTriggerBack, g_objFront, g_objBack;
  
  //helpers
  var g_isWasHover = false;  
  var g_isHoverMode;
  var g_backEventType;
  var g_dataCloseOnBody;
  
  
  /**
  * turn actually the box
  */
  function turnOverActually(isBack){    
    if(!isBack)
      var isBack = g_objFlipBox.hasClass(g_ucShowClass);
    
    var flipbox = g_objFlipBox[0];
    
    //turn to front
    if( isBack == true ) {
      flipbox.classList.remove(g_ucShowClass);
      flipbox.classList.add(g_ucHideClass);
      
      g_objFront.removeAttr('inert');      
      g_objBack.attr('inert', '');
      
      return(true);
    } 
    
    g_objFront.attr('inert', '');
    g_objBack.removeAttr('inert'); 

    //turn to back
    flipbox.classList.remove(g_ucHideClass);
    flipbox.classList.add(g_ucShowClass);    
  }
  
  /**
  * show the back panel
  */
  function turnOverFlipBox(event){
    if(event.target.tagName == 'A' && g_backEventType == "click")
      return(true)
    
    var objClicked = jQuery(event.target);
    
    var isHoverEvent = event.type != "click";
    
    //for mobile mode
    if(isHoverEvent == true)
      g_isWasHover = true;
    
    var isFrontClicked = isHoverEvent == false && objClicked.hasClass(g_classFront);
    
    //don't allow to click on front when trigger button exists
    if(isFrontClicked == true && g_objTriggerFront.length == true){
      
      return(true);
    }
    
    var flipbox = g_objFlipBox[0];    
    var isBack = flipbox.classList.contains(g_ucShowClass);    
    
    //don't allow clicks on desktop
    if(g_isHoverMode == true){
      if(isHoverEvent == false && g_isWasHover == true){
        return(true);
      }
      
    }else{
      //click only mode - don't allow hover
      if(isHoverEvent == true){
        
        //if no trigger button on back - turn by mouse out
        if(isBack == true && g_backEventType == "hover" && event.type == "mouseleave" && g_dataCloseOnBody == false){
          turnOverActually(isBack);
        }
        
        return(true);		  
      }else{		
        
        //don't allow hover on click on trigger mode, on desktop only. on mobile allowed click        
        if(isBack == true && g_backEventType == "hover" && g_isWasHover == false)
          return(true);
      }      
    }
    
    //don't turn back on mouseleave
    if(isBack == false && event.type == "mouseleave")
      return(true);    
    
    turnOverActually(isBack);        
  }

  /**
   * handle keyboard events
   */
  function onKeyDown(event){
    var key = event.key || event.keyCode;
    
    if(key == 'Enter' || key == 13 || key == ' ' || key == 32){
      event.preventDefault();

      var isBack = g_objFlipBox[0].classList.contains(g_ucShowClass); 
      turnOverActually(isBack);
    }
  }
  
  /**
  * init the events
  */
  function initFlipBox(id){    
    //classes
    g_ucShowClass = "uc-show";
    g_ucHideClass = "uc-hide";
    g_classFront = "ue-flip-box__panel--front";
    g_classBack = "ue-flip-box__panel--back";
    
    //obj
    g_dataCloseOnBody = jQuery(flipboxID).data('closeonbody')    
    var objFlipboxWrapper = jQuery(id);
    
    if(objFlipboxWrapper.length == 0){
      console.log("flipbox not found: "+id);
      return(false);
    }
    
    g_objFlipBox = objFlipboxWrapper.find(".ue-flip-box__container");		
    g_objFront = g_objFlipBox.find("."+g_classFront);
    g_objBack = g_objFlipBox.find("."+g_classBack);
    
    //helpers
    var isTouchDevice = 'ontouchstart' in window ? true : false
    
    g_isHoverMode = g_objFlipBox.hasClass("ue-flip-box__container--hover");
    g_backEventType = "hover";    
    
    if(g_isHoverMode == false)
      g_backEventType = "click";
    
    g_objTriggerFront = g_objFlipBox.find(".ue-flip-box__front-trigger");
    g_objTriggerBack = g_objFlipBox.find(".ue-flip-box__back-trigger");
    
    if(g_objTriggerBack.length == false)
      g_backEventType = "hover";
    
    g_objFlipBox.on("keydown", onKeyDown);

    if(g_objTriggerFront.length && g_objTriggerBack.length){
      g_objTriggerBack.on("click", turnOverFlipBox);
      g_objTriggerFront.on("click", turnOverFlipBox);
    }else{
      if ( isTouchDevice ) {
        g_objFlipBox.on("click mouseenter mouseleave", turnOverFlipBox);
      } else {
        
        g_objFlipBox.on("click mouseenter mouseleave focusin focusout", turnOverFlipBox);
        
        if(g_dataCloseOnBody == true){
          
          jQuery('body').on('click', function(event){            
            var objTarget = jQuery(event.target);
            var objParent = objTarget.parents('.ue-flip-box');            
            var flipbox = g_objFlipBox[0];	  
            var isBack = flipbox.classList.contains(g_ucShowClass);
            
            if(!objParent.length && isBack == true){
              turnOverActually(isBack)
            }            
          });
        }        
      }
    }    
  }
  
  initFlipBox(flipboxID);  
  
  // turn back visibility of back panel
  setTimeout( function() { 
    jQuery('.'+g_classBack).css('visibility', 'visible'); 
  },1000);
}
