{# twig vars #}{##}
{% if filter_source == "terms" %}
    {% set items = taxonomy %}
{% else %}
    {% set items = authors %}
{% endif %}
{# end twig vars #}{##}

{% if filter_isajax != "yes" %}

  <div class="ue_taxonomy_toggle" id="{{uc_id}}-toggle">
    <div class="ue_taxonomy_toggle_icon">
      <div class="ue_taxonomy_toggle_icon_open">{{open_toggle_icon_html|raw}}</div>
      <div class="ue_taxonomy_toggle_icon_close">{{close_toggle_icon_html|raw}}</div>
    </div>
  </div>

  <div id="{{uc_id}}-container">
{% endif %}

  <div id="{{uc_id}}" class="ue_taxonomy {{filter_addclass}} {% if layout is empty %}slick-carousel{% endif %}" {% if rtl == "true" %}dir="rtl"{% endif %} data-isfilter="{{is_filter}}" data-filtertype="terms_list" {{filter_attributes|raw}} style="{{filter_style|raw}}" data-filtersource="{{filter_source}}">

    {% if( items is empty and uc_inside_editor == "yes" ) %}No Terms Found{% endif %}

    {% for item in items %}

      {% if force_color_bg == "true" %}    
        {% set color = ucfunc("get_term_custom_field",item.id,color_meta_field) %}
      {% endif %}    

      <a href="javascript:void(0)" class="ue_taxonomy_item {{item.addclass}} {{filter_addclass_item}} " {{item.html_data|raw}} {% if force_color_bg == "true" %}style="background-color:{{color}};"{% endif %} {{item.html_attributes2|raw}}  >

        {% if show_image == "true" %}
          {% set image = ucfunc("get_term_image",item.id,image_meta_field) %}

          {% if image is empty and show_placeholder_image == "true" %}    		
            <div class="ue_taxonomy_image"><img class="uc-term-image" src="{{placeholder_image}}" alt="{{placeholder_image_alt}}" ></div>    		
          {% endif %}

          {% if image is not empty %}    		
             <div class="ue_taxonomy_image"><img class="uc-term-image" src="{{image.thumb_large}}" alt="{{image.title}}" ></div>    		
          {% endif %}
        {% endif %}

        <div class="ue_taxonomy_item_content">
          {% if show_icon == "true" %}
            <span class="ue_taxonomy_item_icon"><i class="{{icon}}"></i></span>
            <span class="ue_taxonomy_item_icon_spacer"></span>
          {% endif %}
          {% if show_taxonomy_title == "true" %}<span  class="ue_taxonomy_item_title">{{item.name|raw}}</span>{% endif %}
          {% if show_number_of_posts == "true" %}
            <span class="ue_taxonomy_item_num_posts_spacer"></span>
            <span class="ue_taxonomy_item_num_posts">{{item.num_posts}}</span>
          {% endif %}
        </div>

        {% if debug_meta == "true" %}
          <div class="ue-debug-meta">
            {% set arrMeta = getTermMeta(item.id) %}
            {{printVar(arrMeta)}}
          </div>
        {% endif %}

        {% if debug_meta == "true" %}
          <div class="debug" style="background-color:lightgray;border:1px solid gray;font-size:10px;">
            {{ucfunc("put_terms_meta_debug",items)}}
          </div>
        {% endif %}

      </a>  

    {% endfor %}  
  </div>

{% if filter_isajax != "yes" %}  
  </div>
{% endif %}