/**
 Copyright 2019 Itay Grudev
 License: MIT
 */

#{{uc_id}} 
{
opacity: 0;
transition: opacity 0.2s;
position: relative;
margin:0 auto;
box-sizing:border-box;
border-radius: 50%;
{% if show_segments == "true" %}
 overflow: hidden;
{% endif %}	
height:{{circle_size}};
width:{{circle_size}};
}

#{{uc_id}}.uc-full-opacity{
opacity: 1;
}

#{{uc_id}}.ciclegraph::before
{
content: "";
position: absolute;
width: 100%;
height: 100%;
border-radius: 50%;
z-index: 2;
{% if show_segments == "true" %}
 pointer-events: none;
{% endif %}	
}

#{{uc_id}} .uc-circle-wrapper{
position: relative;
width: 100%;
height: 100%;
border-radius: 50%;
z-index: 2;
overflow: hidden;
{% if show_segments == "true" %}
 pointer-events: none;
{% endif %}	  
}

#{{uc_id}} .uc-circle-wrapper::before{
content: "";
position: absolute;
width: {{inner_circle_size}};
height: {{inner_circle_size}};
border-radius: 50%;
z-index: 2;
top: 50%;
left: 50%;
transform: translate(-50%, -50%);
box-sizing: content-box;
}

#{{uc_id}} .innerCircle
{
height:{{circle_size}};
width:{{circle_size}};
}

#{{uc_id}}.ciclegraph .uc-circle {
position: absolute;
top: 50%;
left: 50%;
box-sizing:border-box;
display:flex;
align-items:center;
justify-content:center;
flex-direction:column;
cursor:pointer;
text-align: center;
transition:0.5s;
z-index: 5;
outline: none;
{% if show_segments == "false" %}
border-radius: 50%;
{% else %}
background-color: unset;
pointer-events: none;
{% endif %}
}


#{{uc_id}} .ue_btn_txt{
 display: flex;
 justify-content: center;
}

{% if show_segments == "false" %}
  #{{uc_id}} .center-line-wrapper{
    position: absolute;
    left: 50%;
    top: 50%;
    transform-origin: 0% 50%;
    display: flex;
    transition: all .3s;
  }
  #{{uc_id}} .center-line,
  #{{uc_id}} .center-line-spacing{
      transition: all .3s;
  }
{% endif %}

#{{uc_id}}.ciclegraph .uc-circle:hover
{
  transform: scale(1.1,1.1);
}

#{{uc_id}}.ciclegraph .uc-circle:active
{
  transform: scale(0.9,0.9);
}




#{{uc_id}}.ciclegraph .innerCircle
{

  display:flex;
  align-items:center;
  justify-content:center;
  flex-direction: column;
  box-sizing:border-box;
  text-align:center;
  position: relative;
  z-index: 4;
  position: absolute;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
}

#{{uc_id}} .ue_item_image img
{
  display:block;
  width:100%;
  object-fit: {{image_type}};
}


#{{uc_id}}.ciclegraph .innerCircleIcon
{
  text-align:center;
  display: flex;
  justify-content: center;
  align-items: center;
}

#{{uc_id}} .uc-segment-circle
{
position: absolute;
width: 100%;
height: 100%;
border-radius: 50%;
overflow: hidden;
top: 0;
left: 0;
}

#{{uc_id}} .uc-segment
{
display: block;  
overflow: hidden;
position: absolute;
top: -50%;
right: -50%;
width: 100%;
height: 100%;
transform-origin: 0% 100%;
z-index: 10;
cursor: pointer;  
transition: background-color color .3s;  
  
}

#{{uc_id}} .uc-segment-border-inner-circle
{
position: absolute;
width: {{inner_circle_size}};
height: {{inner_circle_size}};
border-radius: 50%;
top: 0;
right: 0;
bottom: 0;
left: 0;
margin: auto;
background: {{inner_circle_background}};
z-index: 2;
display:flex;
align-items:center;
justify-content:center;
flex-direction: column;
text-align:center;
overflow: hidden;
}

#{{uc_id}} .uc-segment-item
{
position: absolute;
left: -100%;
width: 200%;
height: 200%;
}

#{{uc_id}} .uc-separator-outer
{
position: absolute;
height: {{space_between_segments}}px;
background-color: #fff;
top: calc(50% - {{space_between_segments}}px / 2);
left: 50%;
transform-origin: 0 calc({{space_between_segments}}px / 2);
z-index: 2;
}


{% if animation_circle == "true" and show_segments == "false" %}
	@keyframes rotateСlockwise {
      0% {
        transform: rotate(0deg);
      }
      100% {
        transform: rotate(360deg);
      }
    }
	@keyframes rotateConterСlockwise {
      0% {
        transform: rotate(0deg);
      }
      100% {
        transform: rotate(-360deg);
      }
    }
	#{{uc_id}}.uc-full-opacity{
		animation: rotateСlockwise {{animation_circle_speed}}ms linear infinite;
    }
    #{{uc_id}}:hover{
		animation-play-state: paused;
    }
    #{{uc_id}}.uc-full-opacity .innerCircle,
	#{{uc_id}}.uc-full-opacity .uc-circle-inner{
		animation: rotateConterСlockwise {{animation_circle_speed}}ms linear infinite;
    }
    #{{uc_id}}:hover .innerCircle,
	#{{uc_id}}:hover .uc-circle-inner{
		animation-play-state: paused;
    }
    #{{uc_id}}.uc-ajax-loading,
	#{{uc_id}}.uc-ajax-loading .innerCircle{
		animation: none;
    }

{% endif %}	



@media screen and (max-width: 1024px) {
  
#{{uc_id}} {
  height:{{circle_size_tablet}};
  width:{{circle_size_tablet}};
}

#{{uc_id}} .innerCircle
{
  height:{{circle_size_tablet}};
  width:{{circle_size_tablet}};
}
}

@media screen and (max-width: 767px) {
  #{{uc_id}} {
  height:{{circle_size_mobile}};
  width:{{circle_size_mobile}};
}

#{{uc_id}} .innerCircle
{
  height:{{circle_size_mobile}};
  width:{{circle_size_mobile}};
}
}