{{ ucfunc("put_docready_start") }}
    
    var objCarousel = jQuery('#{{uc_id}}');
    var objClonedItems;    
    var itemHolderSelector = '.uc_image_carousel_container_holder';
    
    function equalizeContentHeight(){  
      var dataEqualHeight = objCarousel.data("equal-height");
      
      if(dataEqualHeight == false)
        return(false); 
      
      var objContents = objCarousel.find(".content-padding");
      
      if(!objContents)
        return(false);
      
      var maxHeight = 0;
      
      objContents.each(function(){    
        var objContent = jQuery(this);
        var contentHeight = Math.round(objContent.outerHeight());
        
        if(contentHeight > maxHeight)         
          maxHeight = contentHeight;
      });    
      
      objContents.each(function(){    
        var objContent = jQuery(this);
        objContent.css("min-height", maxHeight+"px");
      });
    }
    
    function initCarousel(){        
      //cloned items fancybox fix
      var objItems = objCarousel.find(itemHolderSelector);
      var itemsNum = objItems.length;
      
      //set data index for each origin item
      for(let i=0; i<itemsNum; i++){
        var objItem = objItems.eq(i);
        
        objItem.attr('data-fancy-index', i);
      }
      
      objCarousel.owlCarousel({
        loop: {{loop}},
        rtl: {{rtl}},
        center:{{center}},
        autoplayTimeout : {{slide_duration}},
        autoplayHoverPause:{{autoplayhoverpause}},
        smartSpeed: {{transition_speed}}, 
        changeItemOnClick:{{change_item_on_click}},
        paddingType: '{{offset_type}}',
        dots: {{show_dots}},
        nav: {{show_arrows}},
        {% if show_arrows == "true" %}navText: [`{{left_arrow_html|ucsafe|raw}}`,`{{right_arrow_html|ucsafe|raw}}`],{% endif %}
        autoplay: {{autoplay}},
        {% if margin_between_items is not empty %}margin: {{margin_between_items}},{% endif %}
        delayBeforeLoad: {{delay_before_load}},  
        autoHeight: {{autoheight}},
        mouseDrag:{{mouse_drag}},
        touchDrag:{{touch_drag}}, 
        progressScroll: {{progress_scroll}},                               
        responsive : {
          0 : {
            items:{{number_of_items_mobile}},
            {% if margin_between_items_mobile is not empty %}margin: {{margin_between_items_mobile}},{% endif %}
            {% if offset_type != "none" %}
              stagePadding: {{offset_number_mobile}},
            {% endif %}
            {% if center == "false" %}
              dotsEach: {{show_dots_each_x_item_mobile}},
            {% endif %}	  
            {% if progress_scroll == 'true' and progress_scroll_distance_mobile is not empty %}
              progressScrollDistanceMobile: {{progress_scroll_distance_mobile}},                  
            {% endif %} 
            slideBy: {{slides_to_change_mobile}},                  
          },
          768 : {
            items:{{number_of_items_tablet}},
            {% if margin_between_items_tablet is not empty %}margin: {{margin_between_items_tablet}},{% endif %}
            {% if offset_type != "none" %}
              stagePadding: {{offset_number_tablet}},
            {% endif %}
            {% if center == "false" %}
              dotsEach: {{show_dots_each_x_item_tablet}},
            {% endif %} 
            {% if progress_scroll == 'true' and progress_scroll_distance_tablet is not empty %}
              progressScrollDistanceTablet: {{progress_scroll_distance_tablet}},                  
            {% endif %}
            slideBy: {{slides_to_change_tablet}},                  
          },
          980 : {
            items:{{number_of_items}},
            {% if margin_between_items is not empty %}margin: {{margin_between_items}},{% endif %}
            {% if offset_type != "none" %}
              stagePadding: {{offset_number}},
            {% endif %}
            {% if center == "false" %} 
              dotsEach: {{show_dots_each_x_item}},
            {% endif %}	
            {% if progress_scroll == 'true' and progress_scroll_distance_mobile is not empty %}
              progressScrollDistance: {{progress_scroll_distance}},                  
            {% endif %} 
            slideBy: {{slides_to_change}},                  
          } 
        }
      });
      
      //wait while carousel init
      setTimeout(function(){        
        var useFancybox = objCarousel.data("lightbox");
        
        if(useFancybox == false)
          return(false);
        
        var imageLinkSelector = '.ue_img_link'; //link on image
        
        //init fancybox only on non cloned items
        var fancyLink = objCarousel.find(".owl-item:not(.cloned) "+imageLinkSelector);
        
        fancyLink.attr("data-fancybox", "gallery")
        
        fancyLink.fancybox({
          loop: true,
          arrows : true,
          backfocus: false
        });
        
        //for cloned items find origin items and trigger it
        objClonedItems = objCarousel.find(".owl-item.cloned");
        
        objClonedItems.on('click', function() {          
          var objClonedItem = jQuery(this);
          var objClonedItemChild = objClonedItem.find(itemHolderSelector);
          var clickedDataFancyIndex = objClonedItemChild.data('fancy-index');
          var objOriginItem = objCarousel.find('.owl-item:not(.cloned) [data-fancy-index='+clickedDataFancyIndex+'] '+imageLinkSelector);
          var objOriginOwlItem = objOriginItem.parent('.owl-item');
          
          objOriginItem.trigger('click');
          
          //do nothing with clicked cloned item https://obu.edu/_resources/ldp/galleries/fancybox/
          return(true);          
        });        
      },300);    
      
      //equalize height of content if needed
      equalizeContentHeight();
      setTimeout(function(){window.dispatchEvent(new Event('resize'));},200)
    }
    
    //pause synced widget
    {% if autoplayhoverpause == "true" %}
    
    //init remote api
    var dataSync = objCarousel.data("sync");
     
    if(dataSync == true) 
      var objRemoteConnectionApi = new UERemoteConnection();
    
    //check if autoplay is true and trigger event 
    function doAction(actionName){
      if(!dataSync || dataSync == false)
        return(false);
      
      var syncedParents = objRemoteConnectionApi.getSyncedElements(objCarousel);
      
      if(!syncedParents)
        return(false); 
      
      var parentsNum = syncedParents.length;
      
      if(!parentsNum)
        return(false);  
      
      jQuery.each(syncedParents, function(index, value){        
        var objParent = jQuery(syncedParents[index]);
        var parentSettings = objParent.data("owl.carousel");
        
        if(!parentSettings)
          return(true);  
        
        var isPlaying = parentSettings.settings.autoplay;
        
        if(isPlaying == false)
          return(true);  
        
        objParent.trigger(actionName);         
      });     
      
    }
    
    function onPyramidMouseOver(){    	
      doAction("stop.owl.autoplay");
    }
    
    function onPyramidMouseOut(){    	
      doAction("play.owl.autoplay");  		
    }
    
    objCarousel.on("mouseover", onPyramidMouseOver);
    objCarousel.on("mouseout", onPyramidMouseOut);    
    
    {% endif %}//end pause synced widget
    
    initCarousel();
    
    objCarousel.on("uc_ajax_refreshed",function(){      
      objCarousel.trigger('destroy.owl.carousel');      
      initCarousel();      
    });
    
    {{ucfunc("put_remote_parent_js","objCarousel")}}  
    
{{ ucfunc("put_docready_end") }}